%% HISCALE spectra scratch paper

 %% Averaging and Smoothing Lab ASOP Spectra
cd('E:\Google Drive\MatlabScripts\Saved Data\HI-SCALE\SavedSpectra');
savedmats = {'ASOP_Bubbling_Clean.mat';'ASOP_Nebulizing_Clean.mat';'S1_Clean.mat';'S1_H2O2_Clean.mat';'S1_heat_Clean.mat';'S2_Clean.mat';'S2_H2O2_Clean.mat';'S2_heat_Clean.mat';'S3_Clean.mat';'SA3Dialysis_Clean.mat';'SA3Filtered_Clean.mat'};

for k = 1:length(savedmats)
	clear specmat normspecmat energy minspec maxspec lowspec upspec stdspec avgspec meanspec
	
	load(savedmats{k});
	
	df = size(normspecmat,1);
	
	meanspec = mean(normspecmat);
	maxspec = max(normspecmat);
	minspec = min(normspecmat);
	stdspec = std(normspecmat);
	upspec = meanspec + (stdspec .* tinv(0.975,df) ./ sqrt(df));
	lowspec = meanspec - (stdspec .* tinv(0.975,df) ./ sqrt(df));
	
	smoothedmat = fnplt(csaps(energy,meanspec));
	
	smooth_energy = smoothedmat(1,:);
	smooth_spec = smoothedmat(2,:);
	
	newfilename = [savedmats{k}(1:end-4), '_smooth.mat'];
	save(newfilename);
	
end

%% Collecting All Smoothed Spectra into One Array
cd('E:\Google Drive\MatlabScripts\Saved Data\HI-SCALE\SavedSpectra');
savedmats = {'ASOP_Bubbling_Clean_smooth_cal.mat';...
	'ASOP_Nebulizing_Clean_smooth_cal.mat';...
	'S1_Clean_smooth_cal.mat';...
	'S1_H2O2_Clean_smooth_cal.mat';...
	'S1_heat_Clean_smooth_cal.mat';...
	'S2_Clean_smooth_cal.mat';...
	'S2_H2O2_Clean_smooth_cal.mat';...
	'S2_heat_Clean_smooth_cal.mat';...
	'S3_Clean_smooth_cal.mat';...
	'SA3Dialysis_Clean_smooth_cal.mat';...
	'SA3Filtered_Clean_smooth_cal.mat'};

bigsmoothmat = [];
bigsmoothenergy = [];
for k = 1:length(savedmats)
	load(savedmats{k},'smooth_spec','smooth_energy');
	bigsmoothenergy = [bigsmoothenergy ; smooth_energy];
	bigsmoothmat = [bigsmoothmat ; smooth_spec];
	
end

%% Offset Plotting
legendlabels = {'Bubbling',...
	'Nebulizing',...
	'S1',...
	'S1 + H_2O_2',...
	'S1 + Heat',...
	'S2',...
	'S2 + H_2O_2',...
	'S2 + Heat',...
	'S3',...
	'SA3 Dialysis',...
	'SA3 Filtered'};
figure;
maxfig(gcf,1);
hold on;
oldorder = [1:3,6,9];
% oldorder = [1:11];
neworder = [4,10,1,5,6,3,8,2,11,9];
for g = 1:numel(oldorder)
	
	if ismember(g,[1,2]);
		groupoffset = 0;
	elseif ismember(g,[3:5]);
			groupoffset = 1;
	elseif ismember(g,[6:7]);
			groupoffset = 2;
	elseif ismember(g,8);
			groupoffset = 3;
	elseif ismember(g,[9:10]);
			groupoffset = 4;
	end
	plot(bigsmoothenergy(oldorder(g),:),bigsmoothmat(oldorder(g),:)+0.7.*g+groupoffset./2-0.62,'LineWidth',2.5);

end
legend(legendlabels(oldorder),'Box','off');
newL = reorderLegend([1,2,3,4,5]);
set(newL,'Box','off');
% legend({'9','11','2','8','3','6','5','1','4','10'});
% legend({'4','10','1','5','6','3','8','2','11','9'});
axis square
xlim([278,320]);
xlabel('Energy (eV)');
ylabel('Optical Density (Normalized)');
title('Lab Produced ASOPs');
set(gca,'FontWeight','bold','FontSize',20,'LineWidth',2,'Color','none');

hv(1) = vline(285.2);
hv(2) = vline(286.7);
hv(3) = vline(288.5);
hv(4) = vline(290.4);

set(hv,'Color',[0.5,0.5,0.5]);

% vline(297.3);
% vline(299.9);


